# Laptop Tracking System - User Manual

## Table of Contents
1. [Introduction](#introduction)
2. [Getting Started](#getting-started)
3. [Dashboard Overview](#dashboard-overview)
4. [Laptop Management](#laptop-management)
5. [Student Management](#student-management)
6. [Class Management](#class-management)
7. [Transaction Management](#transaction-management)
8. [Barcode Generation](#barcode-generation)
9. [Reporting](#reporting)
10. [Troubleshooting](#troubleshooting)

## Introduction

The Laptop Tracking System is a comprehensive web-based application designed to manage the inventory, assignment, and tracking of laptops in an educational institution. The system provides functionality to track laptop assignments to students, generate barcodes for easy identification, and generate reports on laptop status and usage history.

### Key Features
- **Laptop Inventory Management**: Track detailed laptop specifications, status, and assignments
- **Student Management**: Maintain student information and class associations
- **Transaction Tracking**: Record check-in/check-out transactions with audit trails
- **Barcode Generation**: Auto-generate barcodes and QR codes for laptops
- **Reporting**: Generate various reports on laptop status, assignments, and usage
- **Real-time Dashboard**: Monitor system status and key metrics

## Getting Started

### System Requirements
- Modern web browser (Chrome, Firefox, Safari, Edge)
- Internet connection
- Valid user account with appropriate permissions

### Logging In
1. Navigate to the system URL
2. Enter your username/email and password
3. Click "Login" or press Enter
4. If two-factor authentication is enabled, enter the verification code

### Navigation
The system uses a clean, intuitive navigation menu:
- **Dashboard**: Main overview page
- **Laptops**: Laptop management section
- **Students**: Student management section
- **Classes**: Class management section
- **Transactions**: Transaction history and management
- **Reports**: Generate and view reports

## Dashboard Overview

The dashboard provides a real-time overview of the laptop inventory system.

### Key Metrics Displayed
- **Total Laptops**: Total number of laptops in the system
- **Available**: Number of laptops ready for checkout
- **Checked Out**: Number of laptops currently assigned to students
- **In Maintenance**: Number of laptops under repair or maintenance

### Quick Actions
- **Check Out Laptop**: Start the laptop checkout process
- **Check In Laptop**: Return a laptop to inventory
- **View All Laptops**: Access the complete laptop inventory
- **View Reports**: Access reporting functionality

### Recent Activity
The dashboard shows recent transactions and system activity for quick reference.

## Laptop Management

### Viewing Laptops
1. Navigate to **Laptops** from the main menu
2. Use filters to narrow down the list:
   - Filter by class
   - Filter by status (Available, Checked Out, Maintenance, etc.)
3. Browse the laptop table showing:
   - Asset Tag
   - Brand/Model
   - Class assignment
   - Current student (if assigned)
   - Status
   - Actions

### Adding a New Laptop
1. Click **"Add New Laptop"** button
2. Fill in the required information:
   - **Asset Tag**: Auto-generated (format: LT-YYYY-XXX)
   - **Brand**: Laptop manufacturer
   - **Model**: Specific model name
   - **Serial Number**: Manufacturer's serial number
   - **Class**: Select the assigned class
   - **Purchase Date**: Date of acquisition (optional)
   - **Purchase Price**: Cost of the laptop (optional)
3. Optionally assign to a specific student
4. Click **"Add Laptop"**

### Laptop Details
Click **"View"** on any laptop to see detailed information:
- Complete specifications
- Transaction history
- Current assignment status
- Generated barcode

### Barcode Generation
1. From the laptop list, click **"Barcode"** for any laptop
2. The system generates a PDF with the laptop's barcode
3. Print the barcode for physical labeling

### Bulk Barcode Generation
1. Select multiple laptops using checkboxes
2. Click **"Download Selected Barcodes"**
3. System generates a PDF with all selected barcodes

## Student Management

### Viewing Students
1. Navigate to **Students** from the main menu
2. Use filters to find specific students:
   - Search by name or student ID
   - Filter by class
3. Browse student information including:
   - Full name
   - Student ID
   - Class assignment
   - Current laptop (if any)
   - Status

### Adding a New Student
1. Click **"Add Student"** button
2. Fill in required information:
   - **Student ID**: Unique identifier
   - **First Name**: Student's first name
   - **Last Name**: Student's last name
   - **Email**: Email address (optional)
   - **Class**: Select student's class
3. Click **"Add Student"**

### Editing Student Information
1. Click **"Edit"** next to any student
2. Modify the information as needed
3. Click **"Update Student"**

### Student Details
Click **"View"** to see complete student information including:
- Personal details
- Class information
- Laptop assignment history
- Transaction history

## Class Management

### Viewing Classes
1. Navigate to **Classes** from the main menu
2. Browse available classes with:
   - Class name
   - Grade level
   - Section
   - Number of students
   - Number of assigned laptops

### Adding a New Class
1. Click **"Add New Class"** button
2. Fill in class information:
   - **Name**: Class name (e.g., "Grade 10A")
   - **Grade Level**: Academic level
   - **Section**: Class section identifier
   - **Description**: Additional notes (optional)
3. Click **"Add Class"**

### Class Details
Click on any class to view:
- Class information
- List of students in the class
- Laptops assigned to the class
- Class-specific reports

## Transaction Management

### Checking Out a Laptop
1. Click **"Check Out"** from the dashboard or transactions page
2. Enter laptop barcode or select from dropdown
3. Enter student ID or select from searchable dropdown
4. Add notes (optional)
5. Record laptop condition before checkout
6. Click **"Check Out"**

### Checking In a Laptop
1. Click **"Check In"** from the dashboard or transactions page
2. Enter laptop barcode
3. Add notes (optional)
4. Record laptop condition after return
5. Click **"Check In"**

### Transaction History
1. Navigate to **Transactions**
2. View complete transaction log with:
   - Date and time
   - Transaction type (Check Out/Check In)
   - Laptop details
   - Student information
   - Staff member who processed
   - Condition notes
3. Use filters to narrow results:
   - Date range
   - Transaction type
   - Student search

### Transaction Details
Click **"View"** on any transaction to see complete details including:
- Full transaction information
- Laptop specifications
- Student details
- Condition changes
- Notes and damage descriptions

## Barcode Generation

### Individual Barcode Generation
1. Go to laptop details page
2. Click **"Barcode"** button
3. PDF downloads automatically with:
   - Laptop asset tag
   - Barcode image
   - Basic laptop information

### Bulk Barcode Generation
1. From laptop list, select multiple laptops
2. Click **"Download Selected Barcodes"**
3. Single PDF generated with all selected barcodes
4. Useful for batch labeling

### QR Code Features
The system also supports QR code generation containing:
- Laptop asset tag
- Barcode
- Brand and model
- Serial number
- Current assignment status

## Reporting

### Available Reports

#### Laptop Status Report
- Shows all laptops with current status
- Includes assignment information
- Filterable by class
- Exportable to PDF

#### Transaction History Report
- Complete transaction log
- Filterable by date range
- Includes all transaction details
- Shows staff member information

#### Class Reports
- Class-specific laptop assignments
- Student-laptop mappings
- Utilization statistics
- Exportable to PDF

### Generating Reports
1. Navigate to **Reports**
2. Select report type
3. Apply filters as needed
4. Click **"Generate Report"**
5. View or download PDF

### Report Features
- **Real-time Data**: All reports use current system data
- **Filtering Options**: Date ranges, classes, transaction types
- **Export Formats**: PDF format for printing and sharing
- **Detailed Information**: Complete transaction and assignment details

## Troubleshooting

### Common Issues

#### Cannot Check Out Laptop
**Problem**: System prevents laptop checkout
**Possible Causes**:
- Laptop is already checked out
- Student already has a laptop assigned
- Laptop is in maintenance status
**Solution**: Check laptop and student status, resolve conflicts

#### Barcode Not Scanning
**Problem**: Generated barcode doesn't scan properly
**Possible Causes**:
- Print quality issues
- Barcode damage
- Scanner compatibility
**Solution**: Regenerate barcode, ensure high-quality printing

#### Student Not Found
**Problem**: Student search returns no results
**Possible Causes**:
- Incorrect student ID
- Student marked as inactive
- Typo in search query
**Solution**: Verify student ID, check active status

#### Report Generation Fails
**Problem**: PDF reports fail to generate
**Possible Causes**:
- Large dataset
- Server timeout
- Permission issues
**Solution**: Try smaller date ranges, contact administrator

### Getting Help
- Check this manual for detailed procedures
- Contact system administrator for technical issues
- Review transaction history for audit trails
- Use the dashboard for quick status checks

### Best Practices
1. **Regular Backups**: Ensure data is regularly backed up
2. **Barcode Maintenance**: Keep barcodes clean and undamaged
3. **Transaction Records**: Always record condition and notes
4. **User Training**: Ensure all staff are trained on procedures
5. **Regular Audits**: Periodically verify inventory accuracy

---

## System Specifications

### Supported Browsers
- Google Chrome 90+
- Mozilla Firefox 88+
- Safari 14+
- Microsoft Edge 90+

### Barcode Formats
- Code 128 (primary)
- QR Code (with embedded data)
- PDF format for printing

### Data Export
- PDF reports
- Transaction history
- Inventory lists

### Security Features
- User authentication
- Role-based access control
- Audit trails for all transactions
- Secure data storage

---

*This manual is for version 1.0 of the Laptop Tracking System. Please check for updates as new features are added.*