<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class TestDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:test-database {--create-test}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Test database connectivity and check laptops';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Testing database connectivity...');
        
        try {
            // Test basic database connection
            $laptopCount = \App\Models\Laptop::count();
            $this->info("Found {$laptopCount} laptops in database");
            
            // Specifically test LT336113
            $testLaptop = \App\Models\Laptop::where('barcode', 'LT336113')->first();
            if ($testLaptop) {
                $this->info("✓ Laptop with barcode LT336113 found:");
                $this->line("  ID: {$testLaptop->id}");
                $this->line("  Asset Tag: {$testLaptop->asset_tag}");
                $this->line("  Brand: {$testLaptop->brand}");
                $this->line("  Model: {$testLaptop->model}");
                $this->line("  Status: {$testLaptop->status}");
            } else {
                $this->error("✗ Laptop with barcode LT336113 NOT FOUND");
                
                if ($this->option('create-test')) {
                    $this->info('Creating laptop with barcode LT336113...');
                    
                    // Get first class
                    $class = \App\Models\ClassRoom::first();
                    if (!$class) {
                        $this->info('Creating test class...');
                        $class = \App\Models\ClassRoom::create([
                            'name' => 'Test Class',
                            'description' => 'Test class for barcode validation'
                        ]);
                    }
                    
                    $newLaptop = \App\Models\Laptop::create([
                        'asset_tag' => 'LT336113-ASSET',
                        'barcode' => 'LT336113',
                        'brand' => 'Dell',
                        'model' => 'Latitude 3520',
                        'serial_number' => 'DL336113-SER',
                        'status' => 'available',
                        'class_id' => $class->id,
                        'notes' => 'Test laptop created for barcode validation'
                    ]);
                    
                    $this->info("✓ Created laptop with ID {$newLaptop->id} and barcode {$newLaptop->barcode}");
                }
            }
            
        } catch (\Exception $e) {
            $this->error("Database error: " . $e->getMessage());
            $this->error("Stack trace: " . $e->getTraceAsString());
        }
    }
}
