<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use App\Models\UserActivityLog;

class LogUserLogin
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(Login $event): void
    {
        // Update user's last login timestamp
        $event->user->update([
            'last_login_at' => now(),
        ]);

        // Log the login activity
        UserActivityLog::create([
            'user_id' => $event->user->id,
            'action' => 'login',
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
            'created_at' => now(),
        ]);
    }
}
