<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CurrentAssignment extends Model
{
    protected $table = 'current_assignments';

    protected $fillable = [
        'laptop_id', 'student_id', 'checked_out_at', 'checked_out_by'
    ];

    protected $casts = [
        'checked_out_at' => 'datetime'
    ];

    public function laptop()
    {
        return $this->belongsTo(Laptop::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function checkedOutBy()
    {
        return $this->belongsTo(User::class, 'checked_out_by');
    }
}