<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'laptop_id', 'student_id', 'user_id', 'type', 
        'transaction_time', 'notes', 'condition_before', 'condition_after'
    ];

    protected $casts = [
        'transaction_time' => 'datetime'
    ];

    public function laptop()
    {
        return $this->belongsTo(Laptop::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
