<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Login;
use App\Listeners\LogUserLogin;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register login event listener
        Event::listen(
            Login::class,
            LogUserLogin::class,
        );

        // Force HTTPS and proper URL generation for tunnels
        if (config('app.env') !== 'local' || request()->header('x-forwarded-proto') === 'https') {
            URL::forceScheme('https');
        }
        
        // Force root URL for tunnel environments
        if (config('app.url') && str_contains(config('app.url'), 'loca.lt')) {
            URL::forceRootUrl(config('app.url'));
        }
        
        // Remove the problematic setTrustedProxies line - handled by TrustProxies middleware instead
    }
}
