<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // database/migrations/create_laptops_table.php
        Schema::create('laptops', function (Blueprint $table) {
            $table->id();
            $table->string('asset_tag')->unique();
            $table->string('barcode')->unique();
            $table->string('brand');
            $table->string('model');
            $table->string('serial_number')->unique();
            $table->enum('status', ['available', 'checked_out', 'maintenance', 'damaged', 'retired'])
                ->default('available');
            $table->foreignId('class_id')->constrained('classes');
            // Student assignment fields
            $table->string('assigned_student_id')->nullable();
            $table->string('assigned_student_name')->nullable();
            $table->text('notes')->nullable();
            $table->date('purchase_date')->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('laptops');
    }
};
