<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // database/migrations/create_current_assignments_table.php
        Schema::create('current_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('laptop_id')->constrained('laptops');
            $table->foreignId('student_id')->constrained('students');
            $table->timestamp('checked_out_at');
            $table->foreignId('checked_out_by')->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('current_assignments');
    }
};
