<x-guest-layout>
    <x-authentication-card>
        <!-- Header -->
        <div class="text-center mb-8">
            <h2 class="text-3xl font-bold text-gray-800 mb-2">Join Riviera High School</h2>
            <p class="text-gray-600">Create your account to access the laptop tracking system</p>
        </div>

        <!-- Validation Errors -->
        <x-validation-errors class="mb-6" />

        <!-- Registration Form -->
        <form method="POST" action="{{ route('register') }}" class="space-y-6">
            @csrf

            <!-- Name Field -->
            <div>
                <label for="name" class="block text-sm font-semibold text-gray-700 mb-2">
                    Full Name
                </label>
                <div class="relative">
                    <input id="name" type="text" name="name" :value="old('name')"
                           required autofocus autocomplete="name"
                           class="input-modern w-full px-4 py-3 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none transition-all duration-300"
                           placeholder="Enter your full name">
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Email Field -->
            <div>
                <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">
                    Email Address
                </label>
                <div class="relative">
                    <input id="email" type="email" name="email" :value="old('email')"
                           required autocomplete="username"
                           class="input-modern w-full px-4 py-3 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none transition-all duration-300"
                           placeholder="Enter your email address">
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Password Field -->
            <div>
                <label for="password" class="block text-sm font-semibold text-gray-700 mb-2">
                    Password
                </label>
                <div class="relative">
                    <input id="password" type="password" name="password"
                           required autocomplete="new-password"
                           class="input-modern w-full px-4 py-3 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none transition-all duration-300"
                           placeholder="Create a strong password">
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-xs text-gray-500 mt-1">Must be at least 8 characters long</p>
            </div>

            <!-- Confirm Password Field -->
            <div>
                <label for="password_confirmation" class="block text-sm font-semibold text-gray-700 mb-2">
                    Confirm Password
                </label>
                <div class="relative">
                    <input id="password_confirmation" type="password" name="password_confirmation"
                           required autocomplete="new-password"
                           class="input-modern w-full px-4 py-3 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none transition-all duration-300"
                           placeholder="Confirm your password">
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Terms and Privacy -->
            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                <div class="bg-gray-50 p-4 rounded-xl border border-gray-200">
                    <label for="terms" class="flex items-start cursor-pointer">
                        <input id="terms" type="checkbox" name="terms"
                               class="mt-1 rounded border-gray-300 text-[#4CAF50] shadow-sm focus:border-[#4CAF50] focus:ring focus:ring-[#4CAF50] focus:ring-opacity-50">
                        <div class="ml-3">
                            <span class="text-sm text-gray-700">
                                I agree to the
                                <a href="{{ route('terms.show') }}" target="_blank"
                                   class="text-[#3A78C0] hover:text-[#2E5C99] font-medium underline">
                                    Terms of Service
                                </a>
                                and
                                <a href="{{ route('policy.show') }}" target="_blank"
                                   class="text-[#3A78C0] hover:text-[#2E5C99] font-medium underline">
                                    Privacy Policy
                                </a>
                            </span>
                        </div>
                    </label>
                </div>
            @endif

            <!-- Submit Button -->
            <button type="submit"
                    class="btn-primary w-full py-3 px-4 rounded-xl text-white font-semibold text-lg shadow-lg hover:shadow-xl transition-all duration-300 flex items-center justify-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                </svg>
                Create Account
            </button>
        </form>

        <!-- Login Link -->
        <div class="mt-8 text-center">
            <p class="text-gray-600">
                Already have an account?
                <a href="{{ route('login') }}"
                   class="text-[#3A78C0] hover:text-[#2E5C99] font-semibold transition-colors duration-200">
                    Sign in here
                </a>
            </p>
        </div>
    </x-authentication-card>
</x-guest-layout>
