{{-- resources/views/laptops/barcode-pdf.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Barcode - {{ $laptop->asset_tag }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            text-align: center;
        }
        .barcode-container {
            margin: 20px auto;
            padding: 20px;
            border: 2px solid #000;
            display: inline-block;
        }
        .laptop-info {
            margin-bottom: 20px;
        }
        .barcode-image {
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="barcode-container">
        <div class="laptop-info">
            <h2>{{ $laptop->asset_tag }}</h2>
            <p><strong>Brand:</strong> {{ $laptop->brand }}</p>
            <p><strong>Model:</strong> {{ $laptop->model }}</p>
            <p><strong>Class:</strong> {{ $laptop->class->name }}</p>

            @if($laptop->assigned_student_id || $laptop->assigned_student_name)
                <div style="border-top: 1px solid #ccc; margin: 10px 0; padding-top: 10px;">
                    <h3 style="color: #2563eb; margin-bottom: 5px;">Assigned Student</h3>
                    @if($laptop->assigned_student_id)
                        <p><strong>Student ID:</strong> {{ $laptop->assigned_student_id }}</p>
                    @endif
                    @if($laptop->assigned_student_name)
                        <p><strong>Name:</strong> {{ $laptop->assigned_student_name }}</p>
                    @endif
                </div>
            @endif

            @if($laptop->currentAssignment)
                <div style="border-top: 1px solid #ccc; margin: 10px 0; padding-top: 10px;">
                    <h3 style="color: #dc2626; margin-bottom: 5px;">Currently Checked Out</h3>
                    <p><strong>Student:</strong> {{ $laptop->currentAssignment->student->full_name }}</p>
                    <p><strong>Student ID:</strong> {{ $laptop->currentAssignment->student->student_id }}</p>
                    <p><strong>Checked Out:</strong> {{ $laptop->currentAssignment->checked_out_at->format('M d, Y H:i') }}</p>
                </div>
            @endif
        </div>

        <div class="barcode-image">
            <img src="data:image/png;base64,{{ app('App\Services\BarcodeService')->generateBarcode($laptop->barcode) }}" alt="Barcode">
            <p><strong>Barcode:</strong> {{ $laptop->barcode }}</p>
        </div>
    </div>
</body>
</html>