{{-- resources/views/laptops/show.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-start mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">{{ $laptop->asset_tag }}</h2>
                    <p class="text-gray-600">{{ $laptop->brand }} {{ $laptop->model }}</p>
                </div>
                <div class="flex space-x-4">
                    <a href="{{ route('laptops.edit', $laptop) }}" 
                       class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md">
                        Edit
                    </a>
                    <a href="{{ route('laptops.barcode-pdf', $laptop) }}" 
                       class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md">
                        Download Barcode
                    </a>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Info -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Basic Information -->
                    <div class="bg-gray-50 p-6 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4">Basic Information</h3>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Asset Tag</label>
                                <p class="text-gray-900">{{ $laptop->asset_tag }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Barcode</label>
                                <p class="text-gray-900 font-mono">{{ $laptop->barcode }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Brand</label>
                                <p class="text-gray-900">{{ $laptop->brand }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Model</label>
                                <p class="text-gray-900">{{ $laptop->model }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Serial Number</label>
                                <p class="text-gray-900 font-mono">{{ $laptop->serial_number }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Status</label>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                    {{ $laptop->status === 'available' ? 'bg-green-100 text-green-800' : '' }}
                                    {{ $laptop->status === 'checked_out' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                    {{ $laptop->status === 'maintenance' ? 'bg-red-100 text-red-800' : '' }}
                                    {{ $laptop->status === 'damaged' ? 'bg-red-100 text-red-800' : '' }}">
                                    {{ ucfirst($laptop->status) }}
                                </span>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Assigned Class</label>
                                <p class="text-gray-900">{{ $laptop->class->name }}</p>
                            </div>
                            @if($laptop->purchase_date)
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Registration Date</label>
                                <p class="text-gray-900">{{ $laptop->purchase_date->format('M d, Y') }}</p>
                            </div>
                            @endif
                            @if($laptop->purchase_price)
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Purchase Price</label>
                                <p class="text-gray-900">${{ number_format($laptop->purchase_price, 2) }}</p>
                            </div>
                            @endif
                        </div>
                        
                        @if($laptop->notes)
                        <div class="mt-4">
                            <label class="block text-sm font-medium text-gray-700">Notes</label>
                            <p class="text-gray-900">{{ $laptop->notes }}</p>
                        </div>
                        @endif
                    </div>

                    <!-- Current Assignment -->
                    @if($laptop->currentAssignment)
                    <div class="bg-yellow-50 p-6 rounded-lg border-l-4 border-yellow-400">
                        <h3 class="text-lg font-semibold mb-4">Current Assignment</h3>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Student</label>
                                <p class="text-gray-900">{{ $laptop->currentAssignment->student->full_name }}</p>
                                <p class="text-sm text-gray-600">{{ $laptop->currentAssignment->student->student_id }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Checked Out</label>
                                <p class="text-gray-900">{{ $laptop->currentAssignment->checked_out_at->format('M d, Y H:i') }}</p>
                                <p class="text-sm text-gray-600">{{ $laptop->currentAssignment->checked_out_at->diffForHumans() }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Checked Out By</label>
                                <p class="text-gray-900">{{ $laptop->currentAssignment->checkedOutBy->name }}</p>
                            </div>
                        </div>
                        <div class="mt-4">
                            <a href="{{ route('transactions.checkin', ['laptop_barcode' => $laptop->barcode]) }}" 
                               class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md">
                                Check In Laptop
                            </a>
                        </div>
                    </div>
                    @else
                    <div class="bg-green-50 p-6 rounded-lg border-l-4 border-green-400">
                        <h3 class="text-lg font-semibold mb-4">Available for Checkout</h3>
                        <p class="text-gray-600 mb-4">This laptop is currently available and can be checked out to a student.</p>
                        <a href="{{ route('transactions.checkout', ['laptop_barcode' => $laptop->barcode]) }}" 
                           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md">
                            Check Out Laptop
                        </a>
                    </div>
                    @endif

                    <!-- Transaction History -->
                    <div class="bg-white p-6 rounded-lg border border-gray-200">
                        <h3 class="text-lg font-semibold mb-4">Transaction History</h3>
                        @if($laptop->transactions->count() > 0)
                        <div class="space-y-4">
                            @foreach($laptop->transactions->take(10) as $transaction)
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                            {{ $transaction->type === 'check_out' ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800' }}">
                                            {{ $transaction->type === 'check_out' ? 'Checked Out' : 'Checked In' }}
                                        </span>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">{{ $transaction->student->full_name }}</p>
                                        <p class="text-sm text-gray-500">{{ $transaction->transaction_time->format('M d, Y H:i') }}</p>
                                    </div>
                                </div>
                                <div class="text-sm text-gray-500">
                                    by {{ $transaction->user->name }}
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @if($laptop->transactions->count() > 10)
                        <div class="mt-4 text-center">
                            <a href="{{ route('transactions.history', ['laptop_id' => $laptop->id]) }}" 
                               class="text-blue-600 hover:text-blue-800">
                                View all transactions ({{ $laptop->transactions->count() }})
                            </a>
                        </div>
                        @endif
                        @else
                        <p class="text-gray-500">No transactions recorded yet.</p>
                        @endif
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- QR Code -->
                    <div class="bg-white p-6 rounded-lg border border-gray-200 text-center">
                        <h3 class="text-lg font-semibold mb-4">QR Code</h3>
                        <div class="flex justify-center mb-4">
                            <img src="data:image/png;base64,{{ app('App\Services\BarcodeService')->generateQRCodeForLaptop($laptop) }}" 
                                 alt="QR Code" class="w-32 h-32">
                        </div>
                        <p class="text-sm text-gray-600">{{ $laptop->barcode }}</p>
                    </div>

                    <!-- Barcode -->
                    <div class="bg-white p-6 rounded-lg border border-gray-200 text-center">
                        <h3 class="text-lg font-semibold mb-4">Barcode</h3>
                        <div class="flex justify-center mb-4">
                            <img src="data:image/png;base64,{{ app('App\Services\BarcodeService')->generateBarcode($laptop->barcode) }}" 
                                 alt="Barcode" class="h-16">
                        </div>
                        <p class="text-sm text-gray-600 font-mono">{{ $laptop->barcode }}</p>
                    </div>

                    <!-- Quick Stats -->
                    <div class="bg-white p-6 rounded-lg border border-gray-200">
                        <h3 class="text-lg font-semibold mb-4">Quick Stats</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Total Checkouts:</span>
                                <span class="font-semibold">{{ $laptop->transactions()->where('type', 'check_out')->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Last Activity:</span>
                                <span class="font-semibold">
                                    @if($laptop->transactions->count() > 0)
                                        {{ $laptop->transactions->first()->transaction_time->diffForHumans() }}
                                    @else
                                        Never
                                    @endif
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Days in Service:</span>
                                <span class="font-semibold">{{ $laptop->created_at->diffInDays() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection