{{-- resources/views/reports/laptop-status.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-900">Laptop Status Report</h2>
                <div class="flex space-x-4">
                    <a href="{{ route('reports.export-pdf', 'laptop-status') }}"
                        class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Download PDF
                    </a>
                    <button onclick="window.print()"
                            class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                        </svg>
                        Print Report
                    </button>
                </div>
            </div>

            <!-- Summary Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-blue-600">{{ $laptops->total() }}</div>
                    <div class="text-sm text-blue-800">Total Laptops</div>
                </div>
                <div class="bg-green-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-green-600">{{ $laptops->where('status', 'available')->count() }}</div>
                    <div class="text-sm text-green-800">Available</div>
                </div>
                <div class="bg-yellow-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-yellow-600">{{ $laptops->where('status', 'checked_out')->count() }}</div>
                    <div class="text-sm text-yellow-800">Checked Out</div>
                </div>
                <div class="bg-red-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-red-600">{{ $laptops->whereIn('status', ['maintenance', 'damaged'])->count() }}</div>
                    <div class="text-sm text-red-800">Issues</div>
                </div>
            </div>

            <!-- Laptops by Class -->
            @foreach($laptops->groupBy('class.name') as $className => $classLaptops)
            <div class="mb-8">
                <h3 class="text-lg font-semibold mb-4 border-b border-gray-200 pb-2">{{ $className }}</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Asset Tag</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Brand/Model</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Current User</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Since</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($classLaptops->sortBy('asset_tag') as $laptop)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $laptop->asset_tag }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $laptop->brand }} {{ $laptop->model }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                        {{ $laptop->status === 'available' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $laptop->status === 'checked_out' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $laptop->status === 'maintenance' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $laptop->status === 'damaged' ? 'bg-red-100 text-red-800' : '' }}">
                                        {{ ucfirst($laptop->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    @if($laptop->currentAssignment)
                                        {{ $laptop->currentAssignment->student->full_name }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    @if($laptop->currentAssignment)
                                        {{ $laptop->currentAssignment->checked_out_at->format('M d, Y') }}
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endforeach

            <!-- Pagination -->
            <div class="mt-6">
                {{ $laptops->links() }}
            </div>

            <!-- Report Footer -->
            <div class="mt-8 pt-4 border-t border-gray-200 text-sm text-gray-500">
                <p>Report generated on {{ now()->format('F d, Y \a\t H:i') }} by {{ auth()->user()->name }}</p>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    body {
        -webkit-print-color-adjust: exact;
    }
}
</style>
@endsection