{{-- resources/views/reports/pdf/class-report.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Class Report - {{ $class->name }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .summary-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 15px;
            background: #f8f9fa;
            border: 1px solid #dee2e6;
        }
        .summary-item h3 {
            margin: 0 0 5px 0;
            font-size: 18px;
            color: #333;
        }
        .summary-item p {
            margin: 0;
            color: #666;
        }
        .section {
            margin-bottom: 30px;
        }
        .section h2 {
            font-size: 18px;
            color: #333;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #333;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .status-available {
            background-color: #d4edda;
            color: #155724;
        }
        .status-checked_out {
            background-color: #fff3cd;
            color: #856404;
        }
        .status-maintenance {
            background-color: #f8d7da;
            color: #721c24;
        }
        .status-damaged {
            background-color: #f8d7da;
            color: #721c24;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .page-break {
            page-break-before: always;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Class Report: {{ $class->name }}</h1>
        @if($class->grade_level)
            <p>Grade {{ $class->grade_level }} {{ $class->section ? '- ' . $class->section : '' }}</p>
        @endif
        <p>Generated on: {{ date('F d, Y \a\t H:i') }}</p>
    </div>

    <!-- Summary Statistics -->
    <div class="summary">
        <div class="summary-item">
            <h3>{{ $class->students()->count() }}</h3>
            <p>Total Students</p>
        </div>
        <div class="summary-item">
            <h3>{{ $laptops->count() }}</h3>
            <p>Total Laptops</p>
        </div>
        <div class="summary-item">
            <h3>{{ $laptops->where('status', 'available')->count() }}</h3>
            <p>Available Laptops</p>
        </div>
        <div class="summary-item">
            <h3>{{ $laptops->where('status', 'checked_out')->count() }}</h3>
            <p>Checked Out</p>
        </div>
    </div>

    <!-- Laptop Assignments Section -->
    <div class="section">
        <h2>Laptop Assignments</h2>
        <table>
            <thead>
                <tr>
                    <th>Asset Tag</th>
                    <th>Brand/Model</th>
                    <th>Status</th>
                    <th>Current Student</th>
                    <th>Checked Out</th>
                    <th>Serial Number</th>
                </tr>
            </thead>
            <tbody>
                @forelse($laptops as $laptop)
                <tr>
                    <td><strong>{{ $laptop->asset_tag }}</strong></td>
                    <td>
                        <strong>{{ $laptop->brand }}</strong><br>
                        <small>{{ $laptop->model }}</small>
                    </td>
                    <td>
                        <span class="status-badge status-{{ $laptop->status }}">
                            {{ ucfirst(str_replace('_', ' ', $laptop->status)) }}
                        </span>
                    </td>
                    <td>
                        @if($laptop->currentAssignment)
                            <strong>{{ $laptop->currentAssignment->student->full_name }}</strong><br>
                            <small>ID: {{ $laptop->currentAssignment->student->student_id }}</small>
                        @else
                            <em>Not assigned</em>
                        @endif
                    </td>
                    <td>
                        @if($laptop->currentAssignment)
                            {{ $laptop->currentAssignment->checked_out_at->format('M d, Y H:i') }}
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $laptop->serial_number ?? 'N/A' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" style="text-align: center; color: #666;">
                        No laptops assigned to this class.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Students without laptops -->
    <div class="section">
        <h2>Students without Laptops</h2>
        <table>
            <thead>
                <tr>
                    <th>Student ID</th>
                    <th>Name</th>
                    <th>Email</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $studentsWithoutLaptops = $class->students->filter(function($student) {
                        return !$student->currentAssignment;
                    });
                @endphp
                @forelse($studentsWithoutLaptops as $student)
                <tr>
                    <td><strong>{{ $student->student_id }}</strong></td>
                    <td><strong>{{ $student->full_name }}</strong></td>
                    <td>{{ $student->email ?? 'N/A' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="3" style="text-align: center; color: #666;">
                        All students have laptops assigned.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="footer">
        <p>Report generated by {{ auth()->user()->name ?? 'System' }} on {{ date('F d, Y \a\t H:i') }}</p>
        <p>Class: {{ $class->name }} | Students: {{ $class->students()->count() }} | Laptops: {{ $laptops->count() }}</p>
    </div>
</body>
</html>