{{-- resources/views/reports/pdf/laptop-status.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laptop Status Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .stats {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .stat-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 10px;
            border: 1px solid #ddd;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .class-header {
            background-color: #e9ecef;
            font-weight: bold;
            padding: 10px;
            margin: 20px 0 10px 0;
            border-left: 4px solid #007bff;
        }
        .footer {
            margin-top: 30px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            color: #666;
        }
        .status-available { color: #28a745; }
        .status-checked_out { color: #ffc107; }
        .status-maintenance { color: #dc3545; }
        .status-damaged { color: #dc3545; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laptop Status Report</h1>
        <p>Generated on {{ now()->format('F d, Y \a\t H:i') }}</p>
    </div>

    <div class="stats">
        <div class="stat-item">
            <strong>{{ $laptops->count() }}</strong><br>
            Total Laptops
        </div>
        <div class="stat-item">
            <strong>{{ $laptops->where('status', 'available')->count() }}</strong><br>
            Available
        </div>
        <div class="stat-item">
            <strong>{{ $laptops->where('status', 'checked_out')->count() }}</strong><br>
            Checked Out
        </div>
        <div class="stat-item">
            <strong>{{ $laptops->whereIn('status', ['maintenance', 'damaged'])->count() }}</strong><br>
            Issues
        </div>
    </div>

    @foreach($laptops->groupBy('class.name') as $className => $classLaptops)
    <div class="class-header">{{ $className }}</div>

    <table>
        <thead>
            <tr>
                <th>Asset Tag</th>
                <th>Brand/Model</th>
                <th>Status</th>
                <th>Current User</th>
                <th>Since</th>
                <th>Serial Number</th>
            </tr>
        </thead>
        <tbody>
            @foreach($classLaptops->sortBy('asset_tag') as $laptop)
            <tr>
                <td>{{ $laptop->asset_tag }}</td>
                <td>{{ $laptop->brand }} {{ $laptop->model }}</td>
                <td class="status-{{ $laptop->status }}">{{ ucfirst($laptop->status) }}</td>
                <td>
                    @if($laptop->currentAssignment)
                        {{ $laptop->currentAssignment->student->full_name }}
                    @else
                        -
                    @endif
                </td>
                <td>
                    @if($laptop->currentAssignment)
                        {{ $laptop->currentAssignment->checked_out_at->format('M d, Y') }}
                    @else
                        -
                    @endif
                </td>
                <td>{{ $laptop->serial_number }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endforeach

    <div class="footer">
        <p>Report generated by {{ auth()->user()->name ?? 'System' }}</p>
        <p>Total Classes: {{ $laptops->groupBy('class.name')->count() }} | Total Laptops: {{ $laptops->count() }}</p>
    </div>
</body>
</html>