{{-- resources/views/reports/pdf/transaction-history.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Transaction History Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .summary-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 15px;
            background: #f8f9fa;
            border: 1px solid #dee2e6;
        }
        .summary-item h3 {
            margin: 0 0 5px 0;
            font-size: 18px;
            color: #333;
        }
        .summary-item p {
            margin: 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #333;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .status-checkout {
            background-color: #fff3cd;
            color: #856404;
        }
        .status-checkin {
            background-color: #d1ecf1;
            color: #0c5460;
        }
        .condition-excellent { color: #28a745; }
        .condition-good { color: #007bff; }
        .condition-fair { color: #ffc107; }
        .condition-poor, .condition-damaged { color: #dc3545; }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .page-break {
            page-break-before: always;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Transaction History Report</h1>
        <p>Generated on: {{ date('F d, Y \a\t H:i') }}</p>
        @if(isset($date_from) || isset($date_to))
            <p>Date Range: {{ $date_from ?? 'Start' }} to {{ $date_to ?? 'End' }}</p>
        @endif
    </div>

    <!-- Summary Statistics -->
    <div class="summary">
        <div class="summary-item">
            <h3>{{ $transactions->count() }}</h3>
            <p>Total Transactions</p>
        </div>
        <div class="summary-item">
            <h3>{{ $transactions->where('type', 'check_out')->count() }}</h3>
            <p>Check-outs</p>
        </div>
        <div class="summary-item">
            <h3>{{ $transactions->where('type', 'check_in')->count() }}</h3>
            <p>Check-ins</p>
        </div>
        <div class="summary-item">
            <h3>{{ $transactions->unique('laptop_id')->count() }}</h3>
            <p>Unique Laptops</p>
        </div>
    </div>

    <!-- Transactions Table -->
    <table>
        <thead>
            <tr>
                <th>Date/Time</th>
                <th>Type</th>
                <th>Laptop</th>
                <th>Student</th>
                <th>Staff Member</th>
                <th>Condition</th>
                <th>Notes</th>
            </tr>
        </thead>
        <tbody>
            @foreach($transactions as $transaction)
            <tr>
                <td>
                    <strong>{{ $transaction->transaction_time->format('M d, Y') }}</strong><br>
                    <small>{{ $transaction->transaction_time->format('H:i:s') }}</small>
                </td>
                <td>
                    <span class="status-badge {{ $transaction->type === 'check_out' ? 'status-checkout' : 'status-checkin' }}">
                        {{ $transaction->type === 'check_out' ? 'Check Out' : 'Check In' }}
                    </span>
                </td>
                <td>
                    <strong>{{ $transaction->laptop->asset_tag }}</strong><br>
                    <small>{{ $transaction->laptop->brand }} {{ $transaction->laptop->model }}</small>
                </td>
                <td>
                    <strong>{{ $transaction->student->full_name }}</strong><br>
                    <small>ID: {{ $transaction->student->student_id }}</small>
                </td>
                <td>{{ $transaction->user->name }}</td>
                <td>
                    @if($transaction->type === 'check_out')
                        <span class="condition-{{ $transaction->condition_before ?? 'good' }}">
                            Before: {{ ucfirst($transaction->condition_before ?? 'N/A') }}
                        </span>
                    @else
                        <span class="condition-{{ $transaction->condition_after ?? 'good' }}">
                            After: {{ ucfirst($transaction->condition_after ?? 'N/A') }}
                        </span>
                    @endif
                </td>
                <td>
                    @if($transaction->notes)
                        {{ Str::limit($transaction->notes, 50) }}
                    @endif
                    @if($transaction->damage_description)
                        <br><small><strong>Damage:</strong> {{ Str::limit($transaction->damage_description, 30) }}</small>
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Report generated by {{ auth()->user()->name ?? 'System' }} on {{ date('F d, Y \a\t H:i') }}</p>
        <p>Total Records: {{ $transactions->count() }}</p>
    </div>
</body>
</html>