{{-- resources/views/welcome.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Riviera High School Laptop Tracking System - Efficient management of student laptops and devices">
    <meta name="keywords" content="Riviera High School, laptop tracking, student devices, asset management, school technology">

    <title>Riviera High School - Laptop Tracking System</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('apple-touch-icon.png') }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('favicon-32x32.png') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('favicon-16x16.png') }}">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Styles / Scripts -->
    @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
        @vite(['resources/css/app.css', 'resources/css/components.css', 'resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script>
            tailwind.config = {
                theme: {
                    extend: {
                        fontFamily: {
                            sans: ['Instrument Sans', 'ui-sans-serif', 'system-ui', 'sans-serif'],
                        },
                        animation: {
                            'float': 'float 6s ease-in-out infinite',
                            'fade-in': 'fadeIn 1s ease-out',
                            'slide-up': 'slideUp 0.8s ease-out',
                        },
                        keyframes: {
                            float: {
                                '0%, 100%': { transform: 'translateY(0px)' },
                                '50%': { transform: 'translateY(-10px)' }
                            },
                            fadeIn: {
                                'from': { opacity: '0', transform: 'translateY(20px)' },
                                'to': { opacity: '1', transform: 'translateY(0)' }
                            },
                            slideUp: {
                                'from': { opacity: '0', transform: 'translateY(30px)' },
                                'to': { opacity: '1', transform: 'translateY(0)' }
                            }
                        }
                    }
                }
            }
        </script>
    @endif

    <!-- Custom Styles -->
    <style>
        [x-cloak] { display: none !important; }
        .text-shadow {
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="text-white" style="background: linear-gradient(135deg, #3A78C0 0%, #4CAF50 100%); min-height: 100vh;">
<!-- Navigation -->
<nav class="fixed top-0 w-full z-50 bg-[#3A78C0]/90 backdrop-blur-md border-b border-white/20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center">
                        {{-- <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg> --}}
                        <img src="{{ asset('images/Riviera-Logo.png') }}" alt="Riviera High School Logo" class="w-full h-full object-contain">
                    </div>
                    <div>
                        <h1 class="text-lg font-bold">Riviera High School</h1>
                        <p class="text-xs text-white/70">Laptop Tracking System</p>
                    </div>
                </div>

                <!-- Auth Links -->
                @if (Route::has('login'))
                    <div class="flex items-center space-x-4">
                        @auth
                            <a href="{{ url('/dashboard') }}"
                               class="px-4 py-2 bg-[#4CAF50] text-white hover:bg-[#3F8E44] rounded-lg text-sm font-medium transition-all duration-200">
                                Dashboard
                            </a>
                        @else
                            <a href="{{ route('login') }}"
                               class="px-4 py-2 bg-[#FFD700] text-[#212121] hover:bg-[#FBC02D] rounded-lg text-sm font-medium transition-all duration-200">
                                Sign In
                            </a>
                        @endauth
                    </div>
                @endif
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="pt-24 pb-16 px-4 sm:px-6 lg:px-8" style="background: linear-gradient(135deg, #3A78C0 0%, #4CAF50 50%, #3F8E44 100%);">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-16">
                <div class="inline-flex items-center space-x-2 bg-white/20 backdrop-blur-sm rounded-full px-4 py-2 mb-8 border border-white/30">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                    <span class="text-sm font-medium">Smart Asset Management</span>
                </div>

                <h1 class="text-5xl md:text-7xl font-bold mb-6 text-shadow animate-fade-in">
                    Riviera High School
                    <span class="block text-3xl md:text-5xl font-semibold text-white/90 mt-2">
                        Laptop Tracking System
                    </span>
                </h1>

                <p class="text-xl md:text-2xl text-white/80 mb-8 max-w-3xl mx-auto leading-relaxed">
                    Streamline your school's technology asset management with our comprehensive laptop tracking solution.
                    Keep track of every device, monitor assignments, and ensure accountability.
                </p>

                <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                    @auth
                        <a href="{{ url('/dashboard') }}"
                           class="px-8 py-4 bg-[#4CAF50] text-white hover:bg-[#3F8E44] rounded-xl font-semibold text-lg transition-all duration-200 transform hover:scale-105 shadow-lg">
                            Access Dashboard
                        </a>
                    @else
                        <a href="{{ route('login') }}"
                           class="px-8 py-4 bg-[#4CAF50] text-white hover:bg-[#3F8E44] rounded-xl font-semibold text-lg transition-all duration-200 transform hover:scale-105 shadow-lg">
                            Sign In
                        </a>
                        <div class="text-sm text-gray-600 mt-4 text-center">
                            <p>New users must be created by an administrator.</p>
                            <p>Contact your system administrator for access.</p>
                        </div>
                    @endauth
                </div>
            </div>

            <!-- Stats Section -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
                <div class="card-glass rounded-2xl p-8 text-center animate-float">
                    <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold mb-2">500+</h3>
                    <p class="text-white/80">Devices Tracked</p>
                </div>

                <div class="card-glass rounded-2xl p-8 text-center animate-float" style="animation-delay: 2s;">
                    <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold mb-2">1,200+</h3>
                    <p class="text-white/80">Students Served</p>
                </div>

                <div class="card-glass rounded-2xl p-8 text-center animate-float" style="animation-delay: 4s;">
                    <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold mb-2">99.9%</h3>
                    <p class="text-white/80">Uptime Reliability</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-16 px-4 sm:px-6 lg:px-8" style="background: linear-gradient(135deg, #F5F5F5 0%, #E0E0E0 100%);">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold mb-6 text-[#212121]">
                    Powerful Features
                </h2>
                <p class="text-xl text-gray-700 max-w-3xl mx-auto">
                    Everything you need to manage your school's laptop inventory efficiently
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up border border-gray-200">
                    <div class="w-12 h-12 bg-[#3A78C0] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4V2a1 1 0 011-1h8a1 1 0 011 1v2m-9 0h10m-9 0V1m10 3V1m0 3l1 1v16a2 2 0 01-2 2H6a2 2 0 01-2-2V5l1-1z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">Asset Management</h3>
                    <p class="text-gray-600">
                        Complete inventory management with automatic asset tagging, barcode generation, and detailed device information.
                    </p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up" style="animation-delay: 0.2s;">
                    <div class="w-12 h-12 bg-[#4CAF50] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">Check-in/Check-out</h3>
                    <p class="text-gray-600">
                        Streamlined device assignment process with barcode scanning, automatic status updates, and transaction history.
                    </p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up" style="animation-delay: 0.4s;">
                    <div class="w-12 h-12 bg-[#3A78C0] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">Analytics & Reports</h3>
                    <p class="text-gray-600">
                        Comprehensive reporting with device status, usage statistics, and maintenance tracking for informed decision-making.
                    </p>
                </div>

                <!-- Feature 4 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up" style="animation-delay: 0.6s;">
                    <div class="w-12 h-12 bg-[#FFD700] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-[#212121]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">Secure & Reliable</h3>
                    <p class="text-gray-600">
                        Enterprise-grade security with role-based access control, audit trails, and data encryption for peace of mind.
                    </p>
                </div>

                <!-- Feature 5 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up" style="animation-delay: 0.8s;">
                    <div class="w-12 h-12 bg-[#4CAF50] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">Real-time Updates</h3>
                    <p class="text-gray-600">
                        Live dashboard with real-time device status, instant notifications, and automated maintenance reminders.
                    </p>
                </div>

                <!-- Feature 6 -->
                <div class="bg-white rounded-2xl p-8 shadow-lg animate-slide-up" style="animation-delay: 1s;">
                    <div class="w-12 h-12 bg-[#3A78C0] rounded-xl flex items-center justify-center mb-6">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold mb-4 text-[#212121]">User-Friendly</h3>
                    <p class="text-gray-600">
                        Intuitive interface designed for teachers, students, and administrators with mobile-responsive design.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-16 px-4 sm:px-6 lg:px-8" style="background: linear-gradient(135deg, #F5F5F5 0%, #E0E0E0 100%);">
        <div class="max-w-4xl mx-auto text-center">
            <div class="bg-white rounded-3xl p-12 shadow-xl animate-fade-in border border-gray-200">
                <h2 class="text-4xl md:text-5xl font-bold mb-6 text-[#212121]">
                    Ready to Get Started?
                </h2>
                <p class="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
                    Join Riviera High School in revolutionizing our technology asset management.
                    Start tracking your devices efficiently today.
                </p>

                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    @auth
                        <a href="{{ url('/dashboard') }}"
                           class="px-8 py-4 bg-white text-blue-600 hover:bg-blue-50 rounded-xl font-semibold text-lg transition-all duration-200 transform hover:scale-105 shadow-lg">
                            Go to Dashboard
                        </a>
                    @else
                        <a href="{{ route('login') }}"
                           class="px-8 py-4 bg-white text-blue-600 hover:bg-blue-50 rounded-xl font-semibold text-lg transition-all duration-200 transform hover:scale-105 shadow-lg">
                            Sign In to Get Started
                        </a>
                        <p class="text-white/80 text-sm mt-4">
                            Contact your administrator for account access
                        </p>
                    @endauth
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="py-8 px-4 sm:px-6 lg:px-8 border-t border-white/10">
        <div class="max-w-7xl mx-auto text-center">
            <div class="flex items-center justify-center space-x-3 mb-4">
                <div class="w-8 h-8 bg-white/20 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                </div>
                <span class="text-lg font-semibold">Riviera High School</span>
            </div>
            <p class="text-white/60 text-sm">
                Laptop Tracking System &copy; {{ date('Y') }}. Empowering education through technology.
            </p>
        </div>
    </footer>

    <!-- Alpine.js for interactions -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</body>
</html>
