<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LaptopController;
use App\Http\Controllers\StudentController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/laptops/barcode/{barcode}', [LaptopController::class, 'getByBarcode']);
    Route::get('/students/search', [StudentController::class, 'search']);
});

Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/transactions/{transaction}', function (\App\Models\Transaction $transaction) {
        return $transaction->load(['laptop', 'student', 'user']);
    });
});
